﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        private bool[] lteTddEvmSetup = new bool[] { false, false, false };

        public void setLteTddSetupDirty()
        {
            lteTddEvmSetup = new bool[] { false, false, false };
        }

        // Test Procedures
        public int lteTddTest(string standard)
        {
            // Configure variables for LTE TDD 5 MHZ BW Standard
            string testWaveform = "";
            string testName = "";
            int lteIndex = 0;
            switch (standard)
            {
                case "B5M":
                    testWaveform = lteTdd5MhzArb;
                    testName = "LTE TDD 5 MHz Test";
                    vsag.setupParameters("LTE_TDD_5MHZ");
                    dataLog.tstName = "LTETDD 5";
                    break;
                case "B10M":
                    testWaveform = lteTdd10MhzArb;
                    testName = "LTE TDD 10 MHz Test";
                    vsag.setupParameters("LTE_TDD_10MHZ");
                    dataLog.tstName = "LTETDD 10";
                    lteIndex = 1;
                    break;
                case "B20M":
                    testWaveform = lteTdd20MhzArb;
                    testName = "LTE TDD 20 MHz Test";
                    vsag.setupParameters("LTE_TDD_20MHZ");
                    dataLog.tstName = "LTETDD 20";
                    lteIndex = 2;
                    break;
            }

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();

            // For TDD waveforms, external triggering must be used to make sure measurements are made during the RF burst
            bool useExtTrig = true;

            // Configure for External Trigger on Falling Edge of ARB Wrap signal
            vsag.configVsaTrigger("EXTERNAL", 2e-3);

            // We can measure EVM on just the first sub frame, so always just load the first 5 ms of the waveform
            vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain, true, 5e-3);

            // Configure the EVM measurement
            if (testEvm)
            {
                if (lteTddEvmSetup[lteIndex] == false)
                {
                    vsag.configLteTddEvmMeas("ULIN", standard, cellFreqs[0], targetPout);
                    lteTddEvmSetup[lteIndex] = true;
                }
                else
                {
                    vsag.sendXappScpi("INST:SEL LTETDD\n");
                    string cmd = string.Format("SENSe:RADio:STANdard:BANDwidth {0}\n", standard);
                    vsag.sendXappScpi(cmd);
                    //Lib.sendXappScpi(":TRIG:CEVM:SEQ:SOUR IMM\n");
                    //Lib.sendXappScpi("CEVM:EVM:COPY\n");
                }
            }

            // Loop over Frequencies for Low Band
            for (int i = 0; i < cellFreqs.Length; i++)
            {
                dataLog.addResultsHeader("Frequency = " + (cellFreqs[i] / 1e6).ToString("0.0") +
                    " MHz, Output Power = " + targetPout.ToString("0.00") + " dBm");

                // Set VSG and VSA to test frequency
                vsag.setTestFreq(cellFreqs[i]);

                // Servo source until Pout is at correct value
                if (vsag.fftServo)
                    vsag.servoInputPowerFft(targetPout, poutMargin);
                else
                    vsag.servoInputPower(targetPout, poutMargin);

                if (testCurr)
                {
                    // Measure DC Current
                    dcSmu.measCurrent();
                }

                if (testAcpr)
                {
                    // Use the IVI Driver to Measure ACPR
                    if (vsag.fftAcpr)
                        vsag.measLteFftAcpr();
                    else
                        vsag.measLteAcpr();
                }

                if (testHarms)
                {
                    // Measure Harmonics using Spectrum Method
#if M9393
                    bool[] harmsToMeas = new bool[numCellHarms];

                    for (int harmIdx = 0; harmIdx < numCellHarms; harmIdx++)
                    {
                        harmsToMeas[harmIdx] = true;
                    }
                    vsag.measSpecHarms2(harmsToMeas);
#else
                    vsag.measSpecHarms(true, true);
#endif
                }

                if (testEvm)
                {
                    // Measure EVM with X-App
                    // Unlock receiver from driver before starting, lock receiver and update setup when complete
                    vsag.unlockVsa();
                    vsag.setXappFreq(cellFreqs[i]);
                    vsag.measLteTddEvm();
                    vsag.lockVsa();
                    
                    if (useExtTrig)
                    {
                        // Configure for External Trigger on Falling Edge of ARB Wrap signal
                        vsag.configVsaTrigger("EXTERNAL", 2e-3);
                    }
                    vsag.setupVsa(cellFreqs[i], targetPout);
                }

                // Tests complete, setup for next test
                dataLog.nextTest();
            }
            // Put it back to immediate trigger
            vsag.configVsaTrigger("IMMEDIATE");

            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}